﻿using System;
using System.Web;
using System.Linq;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using VIRP;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabKitOrders : EfrBasePage
    {
        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridLabKitOrders.PageIndex = 0;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            //ReplacePageTitle();
            ReplacePageTitle("My Tasks > Lab Kits > New");
        }

        protected void SelectPatients(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridLabKitOrders.SelectedIndex = index;
                int InstitutionId = Convert.ToInt32(GridLabKitOrders.SelectedDataKey.Values[0]);
                int KitTypeId = Convert.ToInt16(GridLabKitOrders.SelectedDataKey.Values[1]);
                Response.Redirect(string.Format("LabKitOrder.aspx?InstitutionId={0}&KitTypeId={1}", InstitutionId, KitTypeId), false);
            }
        }

        protected void ChangeGroupingText(object sender, RepeaterItemEventArgs e)
        {
            Panel PanelPat = (Panel)e.Item.FindControl("PanelPatient");

            if (PanelPat != null)
                PanelPat.GroupingText = "Patients requiring kits";
        }

        protected void ChangeEmptyDataText(object sender, ObjectDataSourceStatusEventArgs e)
        {
            if (e.ReturnValue != null)
            {
                if (!e.ReturnValue.GetType().IsValueType)
                {
                    int RetCount = ((List<LabKitOrderGroup>)e.ReturnValue).Count;
                    if (RetCount == 0)
                        GridLabKitOrders.EmptyDataText = "No patients found for new kit orders.";
                }
            }
        }
        
        protected void ButtonPrint_Click(object sender, EventArgs e)
        {
            Response.Redirect("LabKitsReport.aspx");
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            ButtonOK_Click(sender, e);
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}